/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.epub.opf;

import com.adobe.dp.epub.io.DataSource;
import com.adobe.dp.epub.opf.IDPFFontResource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class AdobeFontResource
extends IDPFFontResource {
    byte[] mask;

    public AdobeFontResource(String name, DataSource source) {
        super(name, source);
    }

    void setXORMask(byte[] mask) {
        this.mask = mask;
    }

    public void serialize(OutputStream out) throws IOException {
        try {
            int len;
            byte[] buffer = new byte[4096];
            InputStream in = this.source.getInputStream();
            boolean first = true;
            while ((len = in.read(buffer)) > 0) {
                if (first && this.mask != null) {
                    first = false;
                    int i = 0;
                    while (i < 1024) {
                        buffer[i] = (byte)(buffer[i] ^ this.mask[i % this.mask.length]);
                        ++i;
                    }
                }
                out.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        out.close();
    }

    public boolean canCompress() {
        return true;
    }
}

