/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.epub.opf;

import com.adobe.dp.epub.opf.Publication;
import com.adobe.dp.epub.opf.Resource;
import com.adobe.dp.epub.util.Translit;
import com.adobe.dp.xml.util.SMapImpl;
import com.adobe.dp.xml.util.XMLSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;

public class OPFResource
extends Resource {
    private static final String opfns = "http://www.idpf.org/2007/opf";
    private static final String dcns = "http://purl.org/dc/elements/1.1/";
    private static final String dctermsns = "http://purl.org/dc/terms/";
    private static final String xsins = "http://www.w3.org/2001/XMLSchema-instance";
    Publication owner;

    public OPFResource(Publication owner, String name) {
        super(name, "application/oebps-package+xml", null);
        this.owner = owner;
    }

    public void parse(InputStream in) throws IOException {
        throw new IOException("not yet implemented");
    }

    public void serialize(OutputStream out) throws IOException {
        Resource r;
        XMLSerializer ser = new XMLSerializer(out);
        ser.startDocument("1.0", "UTF-8");
        SMapImpl nsmap = new SMapImpl();
        nsmap.put(null, "opf", opfns);
        nsmap.put(null, "dcns", dcns);
        nsmap.put(null, "dctermsns", dctermsns);
        nsmap.put(null, "xsins", xsins);
        ser.setPreferredPrefixMap(nsmap);
        SMapImpl attrs = new SMapImpl();
        attrs.put(null, "version", "2.0");
        attrs.put(null, "unique-identifier", "bookid");
        ser.startElement(opfns, "package", attrs, true);
        ser.newLine();
        ser.startElement(opfns, "metadata", null, false);
        ser.newLine();
        Iterator it = this.owner.metadata.iterator();
        int identifierCount = 0;
        while (it.hasNext()) {
            Publication.SimpleMetadata item = (Publication.SimpleMetadata)it.next();
            if (item.ns != null && item.ns.equals(dcns) && item.name.equals("identifier")) {
                attrs = new SMapImpl();
                attrs.put(null, "id", identifierCount == 0 ? "bookid" : "bookid" + identifierCount);
                ++identifierCount;
            } else {
                attrs = null;
            }
            String value = item.value;
            if (this.owner.isTranslit()) {
                value = Translit.translit(value);
            }
            if (item.ns == null) {
                attrs = new SMapImpl();
                attrs.put(null, "name", item.name);
                attrs.put(null, "content", value);
                ser.startElement(opfns, "meta", attrs, false);
                ser.endElement(opfns, "meta");
                ser.newLine();
                continue;
            }
            ser.startElement(item.ns, item.name, attrs, false);
            char[] arr = value.toCharArray();
            ser.text(arr, 0, arr.length);
            ser.endElement(item.ns, item.name);
            ser.newLine();
        }
        ser.endElement(opfns, "metadata");
        ser.newLine();
        ser.startElement(opfns, "manifest", null, false);
        ser.newLine();
        it = this.owner.resources();
        while (it.hasNext()) {
            r = (Resource)it.next();
            if (r == this) continue;
            attrs = new SMapImpl();
            attrs.put(null, "id", this.owner.assignId(r));
            attrs.put(null, "href", this.makeReference(r, null));
            attrs.put(null, "media-type", r.mediaType);
            ser.startElement(opfns, "item", attrs, false);
            ser.endElement(opfns, "item");
            ser.newLine();
        }
        ser.endElement(opfns, "manifest");
        ser.newLine();
        attrs = new SMapImpl();
        attrs.put(null, "toc", this.owner.assignId(this.owner.toc));
        ser.startElement(opfns, "spine", attrs, false);
        ser.newLine();
        it = this.owner.spine();
        while (it.hasNext()) {
            r = (Resource)it.next();
            attrs = new SMapImpl();
            attrs.put(null, "idref", this.owner.assignId(r));
            ser.startElement(opfns, "itemref", attrs, false);
            ser.endElement(opfns, "itemref");
            ser.newLine();
        }
        ser.endElement(opfns, "spine");
        ser.newLine();
        ser.endElement(opfns, "package");
        ser.newLine();
        ser.endDocument();
    }
}

