/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.epub.ops;

import com.adobe.dp.epub.ops.OPSDocument;
import com.adobe.dp.epub.ops.XRef;
import com.adobe.dp.epub.otf.FontSubsetter;
import com.adobe.dp.epub.style.InlineStyleRule;
import com.adobe.dp.xml.util.SMapImpl;
import com.adobe.dp.xml.util.XMLSerializer;
import java.util.Iterator;
import java.util.Vector;

public abstract class Element {
    OPSDocument document;
    String className;
    InlineStyleRule style;
    String elementName;
    String id;
    Vector children = new Vector();
    XRef selfRef;

    Element(OPSDocument document, String name) {
        this.document = document;
        this.elementName = name;
    }

    public abstract String getNamespaceURI();

    public String getElementName() {
        return this.elementName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void add(Object child) {
        this.children.add(child);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.document.setElementId(this, id);
    }

    public Iterator content() {
        return this.children.iterator();
    }

    public Object getLastChild() {
        if (this.children.isEmpty()) {
            return null;
        }
        return this.children.lastElement();
    }

    public XRef getSelfRef() {
        if (this.selfRef == null) {
            this.document.assignId(this);
            this.selfRef = new XRef(this.document.resource, this);
        }
        return this.selfRef;
    }

    SMapImpl getAttributes() {
        SMapImpl attrs = new SMapImpl();
        if (this.className != null) {
            attrs.put(null, "class", this.className);
        }
        if (this.id != null) {
            attrs.put(null, "id", this.id);
        }
        if (this.style != null) {
            attrs.put(null, "style", this.style);
        }
        return attrs;
    }

    public void addFonts(FontSubsetter subsetter) {
        subsetter.push(this);
        try {
            Iterator children = this.content();
            if (children != null) {
                while (children.hasNext()) {
                    Object child = children.next();
                    if (child instanceof Element) {
                        ((Element)child).addFonts(subsetter);
                        continue;
                    }
                    if (!(child instanceof String)) continue;
                    subsetter.play((String)child);
                }
            }
        }
        finally {
            subsetter.pop(this);
        }
    }

    boolean isSection() {
        return false;
    }

    void serialize(XMLSerializer ser) {
        boolean section = this.isSection();
        String ns = this.getNamespaceURI();
        ser.startElement(ns, this.elementName, this.getAttributes(), false);
        if (section) {
            ser.newLine();
        }
        Iterator it = this.content();
        while (it.hasNext()) {
            Object next = it.next();
            if (next instanceof Element) {
                ((Element)next).serialize(ser);
            } else if (next instanceof String) {
                char[] arr = ((String)next).toCharArray();
                ser.text(arr, 0, arr.length);
            }
            if (!section) continue;
            ser.newLine();
        }
        ser.endElement(ns, this.elementName);
    }

    public InlineStyleRule getStyle() {
        return this.style;
    }

    public void setStyle(InlineStyleRule style) {
        this.style = style;
    }
}

