/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.epub.style;

import com.adobe.dp.epub.opf.FontResource;
import com.adobe.dp.epub.opf.StyleResource;
import com.adobe.dp.epub.style.FontFace;
import com.adobe.dp.epub.style.Rule;
import com.adobe.dp.epub.style.Selector;
import com.adobe.dp.epub.style.SimpleSelector;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class Stylesheet {
    StyleResource owner;
    Hashtable rulesBySelector = new Hashtable();
    Vector content = new Vector();

    public Stylesheet(StyleResource owner) {
        this.owner = owner;
    }

    public SimpleSelector getSimpleSelector(String elementName, String className) {
        return new SimpleSelector(elementName, className);
    }

    public Rule findRuleForSelector(Selector selector) {
        return (Rule)this.rulesBySelector.get(selector);
    }

    public Rule getRuleForSelector(Selector selector) {
        Rule rule = (Rule)this.rulesBySelector.get(selector);
        if (rule == null) {
            rule = new Rule(selector);
            this.content.add(rule);
            this.rulesBySelector.put(selector, rule);
        }
        return rule;
    }

    public FontFace createFontFace(FontResource fontResource) {
        FontFace fontFace = new FontFace(this, fontResource);
        this.content.add(fontFace);
        return fontFace;
    }

    public Iterator content() {
        return this.content.iterator();
    }

    public void serialize(PrintWriter pout) {
        Iterator it = this.content();
        while (it.hasNext()) {
            Object cp = it.next();
            if (cp instanceof Rule) {
                ((Rule)cp).serialize(pout);
                continue;
            }
            if (!(cp instanceof FontFace)) continue;
            ((FontFace)cp).serialize(pout);
        }
    }
}

