/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.fb2;

import com.adobe.dp.fb2.FB2AuthorInfo;
import com.adobe.dp.fb2.FB2Binary;
import com.adobe.dp.fb2.FB2Date;
import com.adobe.dp.fb2.FB2DateInfo;
import com.adobe.dp.fb2.FB2Document;
import com.adobe.dp.fb2.FB2DocumentInfo;
import com.adobe.dp.fb2.FB2Element;
import com.adobe.dp.fb2.FB2EmptyLine;
import com.adobe.dp.fb2.FB2FormatException;
import com.adobe.dp.fb2.FB2GenreInfo;
import com.adobe.dp.fb2.FB2Hyperlink;
import com.adobe.dp.fb2.FB2Image;
import com.adobe.dp.fb2.FB2Line;
import com.adobe.dp.fb2.FB2OtherElement;
import com.adobe.dp.fb2.FB2Paragraph;
import com.adobe.dp.fb2.FB2PublishInfo;
import com.adobe.dp.fb2.FB2Section;
import com.adobe.dp.fb2.FB2SequenceInfo;
import com.adobe.dp.fb2.FB2StyledText;
import com.adobe.dp.fb2.FB2Subtitle;
import com.adobe.dp.fb2.FB2TableCell;
import com.adobe.dp.fb2.FB2Text;
import com.adobe.dp.fb2.FB2TextAuthor;
import com.adobe.dp.fb2.FB2Title;
import com.adobe.dp.fb2.FB2TitleInfo;
import com.adobe.dp.fb2.FB2UnknownElement;
import com.adobe.dp.util.Base64;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import java.util.Vector;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class FB2DocumentParser {
    private static final String xlinkNS = "http://www.w3.org/1999/xlink";
    FB2Document doc;
    Vector stylesheets = new Vector();
    Vector genres = new Vector();

    public FB2DocumentParser(FB2Document doc) {
        this.doc = doc;
    }

    public void parse(InputStream in) throws IOException, FB2FormatException {
        if (!in.markSupported()) {
            in = new BufferedInputStream(in);
        }
        in.mark(4);
        byte[] sniff = new byte[4];
        in.read(sniff);
        in.reset();
        if (sniff[0] == 80 && sniff[1] == 75 && sniff[2] == 3 && sniff[3] == 4) {
            try {
                ZipInputStream zip = new ZipInputStream(in);
                zip.getNextEntry();
                in = new BufferedInputStream(zip);
                in.mark(4);
                in.read(sniff);
                in.reset();
            }
            catch (Exception e) {
                throw new FB2FormatException("Zip file structure error");
            }
        }
        if (sniff[0] == -17 && sniff[1] == -69 && sniff[2] == -65) {
            in.skip(3L);
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            XMLHandler handler = new XMLHandler();
            reader.setContentHandler(handler);
            reader.setEntityResolver(handler);
            InputSource source = new InputSource(in);
            reader.parse(source);
            int count = handler.bodyElements.size();
            if (count == 0) {
                throw new FB2FormatException("No body sections found");
            }
            this.doc.bodySections = new FB2Section[count];
            handler.bodyElements.copyInto(this.doc.bodySections);
            this.doc.stylesheets = new String[this.stylesheets.size()];
            this.stylesheets.copyInto(this.doc.stylesheets);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new RuntimeException(e.toString());
        }
        catch (SAXException e) {
            throw new FB2FormatException("XML Syntax error: " + e.getMessage());
        }
    }

    FB2Element createElement(String localName, Attributes attr) {
        String style = attr.getValue("style");
        if (localName.equals("section") || localName.equals("epigraph") || localName.equals("cite") || localName.equals("poem") || localName.equals("stanza")) {
            return new FB2Section(localName);
        }
        if (localName.equals("p")) {
            return new FB2Paragraph(style);
        }
        if (localName.equals("v")) {
            return new FB2Line(style);
        }
        if (localName.equals("date")) {
            return new FB2Date();
        }
        if (localName.equals("text-author")) {
            return new FB2TextAuthor(style);
        }
        if (localName.equals("title")) {
            return new FB2Title();
        }
        if (localName.equals("annotation")) {
            return new FB2Section("annotation");
        }
        if (localName.equals("subtitle")) {
            return new FB2Subtitle(style);
        }
        if (localName.equals("image") || localName.equals("a")) {
            String link = attr.getValue(xlinkNS, "href");
            link = link != null && link.startsWith("#") ? link.substring(1) : null;
            if (localName.equals("a")) {
                return new FB2Hyperlink(link);
            }
            String alt = attr.getValue("alt");
            String title = attr.getValue("title");
            return new FB2Image(link, alt, title);
        }
        if (localName.equals("empty-line")) {
            return new FB2EmptyLine();
        }
        if (localName.equals("style")) {
            return new FB2StyledText(attr.getValue("name"));
        }
        if (localName.equals("strong") || localName.equals("emphasis") || localName.equals("sub") || localName.equals("sup") || localName.equals("strikethrough") || localName.equals("code")) {
            return new FB2Text(localName);
        }
        if (localName.equals("th") || localName.equals("td")) {
            String val = attr.getValue("colspan");
            int colSpan = 1;
            if (val != null) {
                try {
                    colSpan = Integer.parseInt(val);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            val = attr.getValue("rowspan");
            int rowSpan = 1;
            if (val != null) {
                try {
                    rowSpan = Integer.parseInt(val);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            String align = attr.getValue("align");
            return new FB2TableCell(localName, style, align, colSpan, rowSpan);
        }
        if (localName.equals("table") || localName.equals("tr")) {
            return new FB2OtherElement(localName, style);
        }
        return new FB2UnknownElement(localName);
    }

    class Context {
        FB2Element curr;
        Vector children = new Vector();

        Context(FB2Element e) {
            this.curr = e;
        }
    }

    class XMLHandler
    extends DefaultHandler {
        Vector bodyElements = new Vector();
        Vector emails = new Vector();
        Vector homePages = new Vector();
        Vector srcUrls = new Vector();
        Vector sequences = new Vector();
        Vector translators = new Vector();
        FB2TitleInfo currTitleInfo;
        FB2AuthorInfo currAuthorInfo;
        FB2DocumentInfo currDocumentInfo;
        FB2PublishInfo currPublishInfo;
        FB2DateInfo currDateInfo;
        FB2Binary currBinary;
        FB2GenreInfo currGenreInfo;
        Vector authors = new Vector();
        Stack contexts = new Stack();
        StringBuffer acc = new StringBuffer();
        String coverpageImage;

        XMLHandler() {
        }

        private Context getContext() {
            return (Context)this.contexts.peek();
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            throw new SAXException("External entities not allowed");
        }

        private void emptyAcc() {
            if (this.acc.length() > 0) {
                this.acc.replace(0, this.acc.length(), "");
            }
        }

        private String flushAcc() {
            String res = this.acc.toString();
            this.emptyAcc();
            return res;
        }

        private boolean inContent() {
            return !this.contexts.isEmpty();
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inContent()) {
                String text = new String(ch, start, length);
                if (this.getContext().curr.acceptsText()) {
                    this.getContext().children.add(text);
                }
            } else {
                this.acc.append(ch, start, length);
            }
        }

        private void addSequence(Attributes attributes) {
            try {
                String name = attributes.getValue("name");
                String number = attributes.getValue("number");
                if (name != null && number != null) {
                    FB2SequenceInfo sequence = new FB2SequenceInfo();
                    sequence.setName(name);
                    sequence.setNumber(Integer.parseInt(number));
                    this.sequences.add(sequence);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void addAuthor(Vector vector) {
            this.currAuthorInfo = new FB2AuthorInfo();
            vector.add(this.currAuthorInfo);
            this.emails.clear();
            this.homePages.clear();
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.inContent()) {
                Context cx = this.getContext();
                cx.curr.children = new Object[cx.children.size()];
                cx.children.copyInto(cx.curr.children);
                this.contexts.pop();
                if (cx.curr instanceof FB2Title && this.getContext().curr instanceof FB2Section) {
                    ((FB2Section)this.getContext().curr).title = (FB2Title)cx.curr;
                }
            } else if (this.currDateInfo != null) {
                if (localName.equals("date")) {
                    this.currDateInfo.setHumanReadable(this.flushAcc());
                    this.currDateInfo = null;
                }
            } else if (this.currAuthorInfo != null) {
                if (localName.equals("author") || localName.equals("translator")) {
                    Object[] arr;
                    if (this.homePages.size() > 0) {
                        arr = new String[this.homePages.size()];
                        this.homePages.copyInto(arr);
                        this.currAuthorInfo.setHomePages((String[])arr);
                        this.homePages.clear();
                    }
                    if (this.emails.size() > 0) {
                        arr = new String[this.emails.size()];
                        this.emails.copyInto(arr);
                        this.currAuthorInfo.setEmails((String[])arr);
                        this.emails.clear();
                    }
                    this.currAuthorInfo = null;
                } else if (localName.equals("first-name")) {
                    this.currAuthorInfo.setFirstName(this.flushAcc());
                } else if (localName.equals("last-name")) {
                    this.currAuthorInfo.setLastName(this.flushAcc());
                } else if (localName.equals("middle-name")) {
                    this.currAuthorInfo.setMiddleName(this.flushAcc());
                } else if (localName.equals("nickname")) {
                    this.currAuthorInfo.setNickname(this.flushAcc());
                } else if (localName.equals("home-page")) {
                    this.homePages.add(this.flushAcc());
                } else if (localName.equals("email")) {
                    this.emails.add(this.flushAcc());
                }
            } else if (this.currTitleInfo != null) {
                if (localName.equals("title-info") || localName.equals("src-title-info")) {
                    Object[] arr;
                    if (FB2DocumentParser.this.genres.size() > 0) {
                        arr = new FB2GenreInfo[FB2DocumentParser.this.genres.size()];
                        FB2DocumentParser.this.genres.copyInto(arr);
                        this.currTitleInfo.setGenres((FB2GenreInfo[])arr);
                        FB2DocumentParser.this.genres.clear();
                    }
                    if (this.authors.size() > 0) {
                        arr = new FB2AuthorInfo[this.authors.size()];
                        this.authors.copyInto(arr);
                        this.currTitleInfo.setAuthors((FB2AuthorInfo[])arr);
                        this.authors.clear();
                    }
                    if (this.translators.size() > 0) {
                        arr = new FB2AuthorInfo[this.translators.size()];
                        this.translators.copyInto(arr);
                        this.currTitleInfo.setTranslators((FB2AuthorInfo[])arr);
                        this.translators.clear();
                    }
                    if (this.sequences.size() > 0) {
                        arr = new FB2SequenceInfo[this.sequences.size()];
                        this.sequences.copyInto(arr);
                        this.currTitleInfo.setSequences((FB2SequenceInfo[])arr);
                        this.sequences.clear();
                    }
                    this.currTitleInfo = null;
                } else if (localName.equals("book-title")) {
                    this.currTitleInfo.setBookTitle(this.flushAcc());
                } else if (localName.equals("keywords")) {
                    this.currTitleInfo.setKeywords(this.flushAcc());
                } else if (localName.equals("lang")) {
                    this.currTitleInfo.setLanguage(this.flushAcc());
                } else if (localName.equals("src-lang")) {
                    this.currTitleInfo.setSrcLanguage(this.flushAcc());
                } else if (localName.equals("coverpage")) {
                    this.currTitleInfo.setCoverpageImage(this.coverpageImage);
                    this.coverpageImage = null;
                }
            } else if (this.currDocumentInfo != null) {
                if (localName.equals("document-info")) {
                    Object[] arr;
                    if (this.authors.size() > 0) {
                        arr = new FB2AuthorInfo[this.authors.size()];
                        this.authors.copyInto(arr);
                        this.currDocumentInfo.setAuthors((FB2AuthorInfo[])arr);
                        this.authors.clear();
                    }
                    if (this.srcUrls.size() > 0) {
                        arr = new String[this.srcUrls.size()];
                        this.srcUrls.copyInto(arr);
                        this.currDocumentInfo.setSrcUrls((String[])arr);
                        this.srcUrls.clear();
                    }
                    this.currDocumentInfo = null;
                } else if (localName.equals("program-used")) {
                    this.currDocumentInfo.setProgramUsed(this.flushAcc());
                } else if (localName.equals("src-url")) {
                    this.srcUrls.add(this.flushAcc());
                } else if (localName.equals("src-ocr")) {
                    this.currDocumentInfo.setSrcOcr(this.flushAcc());
                } else if (localName.equals("version")) {
                    this.currDocumentInfo.setVersion(this.flushAcc());
                } else if (localName.equals("id")) {
                    this.currDocumentInfo.setId(this.flushAcc());
                }
            } else if (this.currPublishInfo != null) {
                if (localName.equals("publish-info")) {
                    if (this.sequences.size() > 0) {
                        Object[] arr = new FB2SequenceInfo[this.sequences.size()];
                        this.sequences.copyInto(arr);
                        this.currPublishInfo.setSequences((FB2SequenceInfo[])arr);
                        this.sequences.clear();
                    }
                    this.currPublishInfo = null;
                } else if (localName.equals("publisher")) {
                    this.currPublishInfo.setPublisher(this.flushAcc());
                } else if (localName.equals("city")) {
                    this.currPublishInfo.setCity(this.flushAcc());
                } else if (localName.equals("year")) {
                    this.currPublishInfo.setYear(this.flushAcc());
                } else if (localName.equals("book-name")) {
                    this.currPublishInfo.setBookName(this.flushAcc());
                } else if (localName.equals("isbn")) {
                    this.currPublishInfo.setISBN(this.flushAcc());
                }
            } else if (this.currBinary != null) {
                this.currBinary.setData(Base64.decode(this.flushAcc()));
                this.currBinary = null;
            } else if (localName.equals("stylesheet")) {
                FB2DocumentParser.this.stylesheets.add(this.flushAcc());
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.inContent()) {
                FB2Element element = FB2DocumentParser.this.createElement(localName, attributes);
                String id = attributes.getValue("id");
                if (id != null) {
                    element.id = id;
                    FB2DocumentParser.this.doc.idMap.put(id, element);
                }
                this.getContext().children.add(element);
                this.contexts.push(new Context(element));
            } else if (this.currAuthorInfo != null) {
                this.emptyAcc();
            } else if (this.currDateInfo == null) {
                if (this.currTitleInfo != null) {
                    String ref;
                    if (localName.equals("author")) {
                        this.addAuthor(this.authors);
                    } else if (localName.equals("translator")) {
                        this.addAuthor(this.translators);
                    } else if (localName.equals("genre")) {
                        this.currGenreInfo = new FB2GenreInfo();
                        String match = attributes.getValue("match");
                        if (match != null) {
                            try {
                                this.currGenreInfo.setMatch(Integer.parseInt(match));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    } else if (localName.equals("sequence")) {
                        this.addSequence(attributes);
                    } else if (localName.equals("date")) {
                        this.currDateInfo = new FB2DateInfo();
                        String date = attributes.getValue("value");
                        this.currDateInfo.setMachineReadable(date);
                        this.currTitleInfo.setDate(this.currDateInfo);
                    } else if (localName.equals("annotation")) {
                        FB2Section annot = new FB2Section("annotation");
                        this.contexts.push(new Context(annot));
                        this.currTitleInfo.setAnnotation(annot);
                    } else if (localName.equals("coverpage")) {
                        this.coverpageImage = null;
                    } else if (localName.equals("image") && (ref = attributes.getValue(FB2DocumentParser.xlinkNS, "href")).startsWith("#")) {
                        this.coverpageImage = ref.substring(1);
                    }
                    this.emptyAcc();
                } else if (this.currDocumentInfo != null) {
                    if (localName.equals("autor")) {
                        this.addAuthor(this.authors);
                    } else if (localName.equals("date")) {
                        this.currDateInfo = new FB2DateInfo();
                        String date = attributes.getValue("value");
                        this.currDateInfo.setMachineReadable(date);
                        this.currDocumentInfo.setDate(this.currDateInfo);
                    } else if (localName.equals("history")) {
                        FB2Section annot = new FB2Section("history");
                        this.contexts.push(new Context(annot));
                        this.currDocumentInfo.setHistory(annot);
                    }
                    this.emptyAcc();
                } else if (this.currPublishInfo != null) {
                    if (localName.equals("sequence")) {
                        this.addSequence(attributes);
                    }
                    this.emptyAcc();
                } else if (this.currBinary == null) {
                    if (localName.equals("body")) {
                        FB2Section body = new FB2Section("body");
                        body.name = attributes.getValue("name");
                        this.bodyElements.add(body);
                        this.contexts.push(new Context(body));
                    } else if (localName.equals("document-info")) {
                        this.currDocumentInfo = new FB2DocumentInfo();
                        this.authors.clear();
                        this.srcUrls.clear();
                        FB2DocumentParser.this.doc.documentInfo = this.currDocumentInfo;
                    } else if (localName.equals("title-info")) {
                        this.currTitleInfo = new FB2TitleInfo();
                        this.authors.clear();
                        this.sequences.clear();
                        this.translators.clear();
                        FB2DocumentParser.this.genres.clear();
                        FB2DocumentParser.this.doc.titleInfo = this.currTitleInfo;
                    } else if (localName.equals("src-title-info")) {
                        this.currTitleInfo = new FB2TitleInfo();
                        this.authors.clear();
                        FB2DocumentParser.this.doc.srcTitleInfo = this.currTitleInfo;
                    } else if (localName.equals("publish-info")) {
                        FB2DocumentParser.this.doc.publishInfo = this.currPublishInfo = new FB2PublishInfo();
                    } else if (localName.equals("binary")) {
                        this.currBinary = new FB2Binary();
                        String id = attributes.getValue("id");
                        String contentType = attributes.getValue("content-type");
                        FB2DocumentParser.this.doc.binaryResources.put(id, this.currBinary);
                        this.currBinary.setMediaType(contentType);
                        this.emptyAcc();
                    } else if (localName.equals("stylesheet")) {
                        this.emptyAcc();
                    }
                }
            }
        }
    }
}

