/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.otf;

import com.adobe.dp.otf.FileFontInputStream;
import com.adobe.dp.otf.FontInputStream;
import com.adobe.dp.otf.FontLocator;
import com.adobe.dp.otf.FontProperties;
import com.adobe.dp.otf.OpenTypeFont;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;

public abstract class SimpleFontLocator
extends FontLocator {
    private Hashtable fontMap = new Hashtable();

    protected SimpleFontLocator() {
        this.collectFonts(this.fontMap);
    }

    protected abstract Iterator getStreamNames();

    protected abstract FontInputStream getStream(String var1) throws IOException;

    protected void collectFonts(Hashtable map) {
        Iterator streams = this.getStreamNames();
        while (streams.hasNext()) {
            String name = (String)streams.next();
            try {
                OpenTypeFont font;
                FontInputStream in = this.getStream(name);
                if (in == null || !(font = new OpenTypeFont(in, true)).canEmbedForReading()) continue;
                FontProperties key = new FontProperties(font.getFamilyName(), font.getWeight(), font.getStyle());
                map.put(key, name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean hasFont(FontProperties key) {
        FontProperties key1;
        String fileName = (String)this.fontMap.get(key);
        if (fileName == null && (fileName = (String)this.fontMap.get(key1 = new FontProperties(key.getFamilyName(), key.getWeight() + 100, key.getStyle()))) == null) {
            key1 = new FontProperties(key.getFamilyName(), key.getWeight() - 100, key.getStyle());
            fileName = (String)this.fontMap.get(key);
            if (fileName == null) {
                return false;
            }
        }
        return true;
    }

    public FontInputStream locateFont(FontProperties key) throws IOException {
        File file;
        FontProperties key1;
        String fileName = (String)this.fontMap.get(key);
        if (fileName == null && (fileName = (String)this.fontMap.get(key1 = new FontProperties(key.getFamilyName(), key.getWeight() + 100, key.getStyle()))) == null) {
            key1 = new FontProperties(key.getFamilyName(), key.getWeight() - 100, key.getStyle());
            fileName = (String)this.fontMap.get(key);
            if (fileName == null) {
                return null;
            }
        }
        if (!(file = new File(fileName)).canRead()) {
            return null;
        }
        return new FileFontInputStream(file);
    }
}

